	function h = LATTICE_FIR_2_h(k)

	% 	Determines the impulse response from the coefficients of a 
	%	nonrecursive lattice FIR filter.
	
	% 	Example: k = [1 0.25 0.5 1/3] which yields
	% 	h = [1 13/24 5/8 1/3]
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2001-02-11
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
 
	Nk = length(k);
	h = [1 k(2)];
	for m = 2:Nk-1
		h = [h 0]+[0 k(m+1)*fliplr(h)];
	end
